; example1.nsi
;
; This script is perhaps one of the simplest NSIs you can make. All of the
; optional settings are left to their default settings. The installer simply 
; prompts the user asking them where to install, and drops a copy of example1.nsi
; there. 
Unicode true

!include x64.nsh
!include MUI.nsh

;--------------------------------
; SilentInstall normal
; The name of the installer
; SilentInstall silent

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_LANGUAGE "Russian"

Name "TEPOCC USB-COM"

; The file to write
OutFile "TTVCOMInst.exe"

ShowInstDetails show

; The default installation directory
InstallDir $TEMP\TTVCOM

; Request application privileges for Windows Vista
RequestExecutionLevel admin

; The stuff to install
Section "" ;No components page, name is not important

  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File TerossVCOM.INF
  File dpinst_x86.exe
  File dpinst_x64.exe
  File /r "ru-RU"
    
SectionEnd ; end the section

Section "Install TTVCOM Driver"
	${If} ${RunningX64}
	;Exec $TEMP\TTVCOM\dpinst_x64.exe
	;ExecShell "open" "$TEMP\TTVCOM\dpinst_x64.exe"
	ExecWait '"$TEMP\TTVCOM\dpinst_x64.exe"'

	${Else}
	;Exec $TEMP\TTVCOM\dpinst_x86.exe
	;ExecShell "open" "$TEMP\TTVCOM\dpinst_x86.exe"
	ExecWait '"$TEMP\TTVCOM\dpinst_x86.exe"'
	${EndIf}
SectionEnd